<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Category extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'parent_id',
        'status',
        'order',
        'icon',
        'image',
        'banner',
        'short_description',
        'description',
        'meta',
    ];

    protected $casts = [
        'status' => 'boolean',
        'meta' => 'array',
    ];

    // Relationship for child categories
    public function children(): HasMany
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    // Relationship for parent category
    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }
}
