<?php

namespace App\Models;
use App\Models\Profile;

use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'email',
        'phone',
        'website',
        'icon',
        'logo',
        'banner',
        'short_description',
        'description',
        'meta',
        'status',
        'order',
    ];

    protected $casts = [
        'meta' => 'array',
        'status' => 'boolean',
    ];

    public function profiles()
    {
        return $this->hasMany(Profile::class);
    }
}
