<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Lead extends Model
{
    protected $fillable = [
        'name',
        'phone',
        'email',
        'note',
        'reference',
        'portal',
        'status',
        'stage_id',
        'portal_lead_id',
        'user_id',
        'company_id',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    /**
     * Automatically generate UUID when creating a new lead.
     */
    protected static function boot(): void
    {
        parent::boot();

        static::creating(function ($lead) {
            if (empty($lead->uuid)) {
                $lead->uuid = (string) Str::uuid();
            }
        });
    }

    /**
     * Use UUID in route model binding instead of ID.
     */
    public function getRouteKeyName()
    {
        return 'uuid';
    }

    public function stage()
    {
        return $this->belongsTo(LeadStage::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
