<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LeadStage extends Model
{
    protected $fillable = [
        'name',
        'parent_id',
        'order',
        'status',
        'data',
        'company_id',
    ];

    protected $casts = [
        'status' => 'boolean',
        'data'   => 'array',
    ];

    public function parent()
    {
        return $this->belongsTo(LeadStage::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(LeadStage::class, 'parent_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    
}

