<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Location extends Model
{
    protected $fillable = [
        'name',
        'title',
        'slug',
        'parent_id',
        'latitude',
        'longitude',
        'image',
        'banner',
        'icon',
        'short_description',
        'description',
        'meta',
        'data',
        'status',
        'order',
    ];

    protected $casts = [
        'meta' => 'array',
        'data' => 'array',
        'status' => 'boolean',
        'latitude' => 'decimal:7',
        'longitude' => 'decimal:7',
    ];

    // Auto-generate slug from name if not provided
    public static function booted()
    {
        static::creating(function ($location) {
            if (empty($location->slug)) {
                $location->slug = Str::slug($location->name);
            }
        });

        static::updating(function ($location) {
            if (empty($location->slug)) {
                $location->slug = Str::slug($location->name);
            }
        });
    }

    // Parent relationship
    public function parent()
    {
        return $this->belongsTo(Location::class, 'parent_id');
    }

    // Children
    public function children()
    {
        return $this->hasMany(Location::class, 'parent_id');
    }
}
