<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Pipeline extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'status',
        'stage_id',
        'company_id',
        'user_id',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    /* ================= Relations ================= */

    // Default / current stage
    public function stage()
    {
        return $this->belongsTo(LeadStage::class, 'stage_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // For future role assignment (pivot: pipeline_role)
    public function roles()
    {
        return $this->belongsToMany(
            \Spatie\Permission\Models\Role::class,
            'pipeline_role'
        );
    }
}
