<?php

namespace App\Models;
use App\Models\User;
use App\Models\Company;

use Illuminate\Database\Eloquent\Model;

class Profile extends Model
{
    protected $fillable = [
        'user_id','company_id','nickname', 'avatar', 'banner', 'phone', 'website', 'reference',
        'whatsapp', 'linkedin', 'facebook', 'instagram', 'youtube', 'tiktok', 'twitter',
        'position', 'department', 'reports_to_user_id',
        'languages', 'locations', 'about', 'data',
    ];

    protected $casts = [
        'languages' => 'array',
        'locations' => 'array',
        'data' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function reportsTo()
    {
        return $this->belongsTo(User::class, 'reports_to_user_id');
    }
}
