<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PropertyDeveloper extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'slug', 'email', 'phone', 'website', 'address',
        'logo', 'banner', 'icon',
        'title', 'short_description', 'description',
        'meta', 'data',
        'status', 'order',
    ];

    protected $casts = [
        'status' => 'boolean',
        'meta' => 'array',
        'data' => 'array',
    ];
}

