<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Schedule extends Model
{
    protected $fillable = [
        'schedule_date',
        'morning_location',
        'morning_start_time',
        'morning_end_time',
        'evening_location',
        'evening_start_time',
        'evening_end_time',
        'per_customer_time',
        'fees',
        'user_id',
        'company_id',
        'status',
        'data',
    ];

    protected $casts = [
        'schedule_date' => 'date',
        'status' => 'boolean',
        'data' => 'array',
    ];

    // ✅ Add this relationship
    public function slots()
    {
        return $this->hasMany(ScheduleSlot::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
