<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Service extends Model
{
    protected $fillable = [
        'name',
        'slug',

        // Relations
        'category_id',
        'parent_id',
        'user_id',
        'company_id',

        // Status & order
        'status',
        'order',

        // Media
        'icon',
        'image',
        'banner',

        // Content
        'short_description',
        'description',

        // Extra data
        'data',
        'meta',
    ];

    protected $casts = [
        'status' => 'boolean',
        'data'   => 'array',
        'meta'   => 'array',
    ];

    /* ==========================
     | Relationships
     |==========================*/

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(Service::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(Service::class, 'parent_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }
}
