<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profiles', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')->constrained()->cascadeOnDelete()->index();
            $table->foreignId('reports_to_user_id')->nullable()->index();
            $table->foreign('reports_to_user_id', 'fk_profiles_reports_to')
                ->references('id')
                ->on('users')
                ->nullOnDelete();

            // Media
            $table->string('avatar')->nullable();
            $table->string('banner')->nullable();

            // Contact
            $table->string('nickname')->nullable();
            $table->string('phone')->nullable();
            $table->string('whatsapp')->nullable();
            $table->string('website')->nullable();
            $table->string('reference')->nullable();

            // Social
            $table->string('linkedin')->nullable();
            $table->string('facebook')->nullable();
            $table->string('instagram')->nullable();
            $table->string('youtube')->nullable();
            $table->string('tiktok')->nullable();
            $table->string('twitter')->nullable();

            // Professional
            $table->string('position')->nullable();
            $table->string('department')->nullable();

            // Structured fields
            $table->json('languages')->nullable();
            $table->json('locations')->nullable();
            $table->json('data')->nullable();

            // Content
            $table->longText('about')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profiles');
    }
};
