<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();

            $table->string('name');
            $table->string('slug')->unique();
            $table->foreignId('parent_id')->nullable()->constrained('categories')->nullOnDelete();
            $table->boolean('status')->default(true); // active or inactive
            $table->integer('order')->default(0);

            // Media
            $table->string('icon')->nullable();
            $table->string('image')->nullable();
            $table->string('banner')->nullable();

            // Content
            $table->string('short_description')->nullable();
            $table->longText('description')->nullable();
            $table->json('data')->nullable();

            // Meta / SEO
            $table->json('meta')->nullable(); // can store title, keywords, og tags, etc.

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
