<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();

            // Basic info
            $table->string('name');
            $table->string('slug')->unique();

            // Contact
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('website')->nullable();

            // Media
            $table->string('logo')->nullable();
            $table->string('banner')->nullable();
            $table->string('icon')->nullable();

            // Content
            $table->string('short_description')->nullable();
            $table->longText('description')->nullable();

            // Meta / extra
            $table->json('meta')->nullable();

            // Status & ordering
            $table->boolean('status')->default(true);
            $table->integer('order')->default(0);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
