<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up(): void
{
    Schema::table('profiles', function (Blueprint $table) {

        if (!Schema::hasColumn('profiles', 'company_id')) {
            $table->unsignedBigInteger('company_id')->nullable()->after('user_id');
        }

        $table->foreign('company_id', 'profiles_company_id_fk')
            ->references('id')
            ->on('companies')
            ->nullOnDelete();
    });
}


public function down(): void
{
    Schema::table('profiles', function (Blueprint $table) {
        $table->dropForeign('profiles_company_id_fk');
        $table->dropColumn('company_id');
    });
}


};
