<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();

            // Basic info
            $table->string('name');
            $table->string('slug')->unique();

            // Relations
            $table->foreignId('category_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('services')
                ->nullOnDelete();

            $table->foreignId('user_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            $table->foreignId('company_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            // Status & order
            $table->boolean('status')->default(true);
            $table->integer('order')->nullable();

            // Media
            $table->string('icon')->nullable();
            $table->string('image')->nullable();
            $table->string('banner')->nullable();

            // Content
            $table->string('short_description', 255)->nullable();
            $table->longText('description')->nullable();

            // Extra data
            $table->json('data')->nullable();
            $table->json('meta')->nullable();

            $table->timestamps();

            // Indexes (performance)
            $table->index(['status', 'order']);
            $table->index('category_id');
            $table->index('company_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
