<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('property_developers', function (Blueprint $table) {
            $table->id();
            
            // Basic info
            $table->string('name');
            $table->string('slug')->unique(); 
            $table->string('email')->nullable()->unique();
            $table->string('phone')->nullable();
            $table->string('website')->nullable();
            $table->text('address')->nullable();

            // Media
            $table->string('logo')->nullable();
            $table->string('banner')->nullable();
            $table->string('icon')->nullable();

            // Content
            $table->string('title')->nullable();
            $table->string('short_description')->nullable();
            $table->longText('description')->nullable(); // long description

            // Meta / extra
            $table->json('meta')->nullable(); // meta_title, meta_keywords, meta_description
            $table->json('data')->nullable(); // extra JSON data if needed

            // Status & ordering
            $table->boolean('status')->default(true);
            $table->integer('order')->default(0);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('property_developers');
    }
};

