<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('locations', function (Blueprint $table) {
            $table->id();

            // Basic
            $table->string('name');
            $table->string('title')->nullable();
            $table->string('slug')->unique();

            // Hierarchy
            $table->foreignId('parent_id')
                  ->nullable()
                  ->constrained('locations')
                  ->nullOnDelete();

            // Map
            $table->decimal('latitude', 10, 7)->nullable();
            $table->decimal('longitude', 10, 7)->nullable();

            // Media
            $table->string('image')->nullable();
            $table->string('banner')->nullable();
            $table->string('icon')->nullable();

            // Content
            $table->string('short_description')->nullable();
            $table->longText('description')->nullable();

            // Meta / extra
            $table->json('meta')->nullable();
            $table->json('data')->nullable();

            // Status & ordering
            $table->boolean('status')->default(true);
            $table->integer('order')->default(0);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('locations');
    }
};
