<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('schedules', function (Blueprint $table) {
            $table->id();

            // 📅 Schedule date
            $table->date('schedule_date');

            // Morning shift
            $table->string('morning_location');
            $table->time('morning_start_time');
            $table->time('morning_end_time');

            // Evening shift
            $table->string('evening_location')->nullable();
            $table->time('evening_start_time')->nullable();
            $table->time('evening_end_time')->nullable();

            // Per customer
            $table->integer('per_customer_time')->default(30); // minutes

            // Fees
            $table->decimal('fees', 10, 2)->default(0);

            // Extra JSON data
            $table->json('data')->nullable();

            // Relations
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('company_id')->constrained()->cascadeOnDelete();

            // Status
            $table->boolean('status')->default(true);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('schedules');
    }
};
