<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();

            $table->foreignId('slot_id')
                ->constrained('schedule_slots')
                ->cascadeOnDelete();

            $table->foreignId('user_id')
                ->constrained()
                ->cascadeOnDelete();

            $table->string('customer_name');
            $table->string('customer_reference')->nullable();
            $table->string('customer_phone', 20);

            // Normal string fields (no ENUM)
            $table->string('stage')->default('new');      // new, follow_up, completed
            $table->string('status')->default('pending'); // pending, confirmed, cancelled, completed

            // Extra dynamic data (age, gender, notes, etc.)
            $table->json('data')->nullable();

            $table->timestamps();

            // Recommended indexes
            $table->index('slot_id');
            $table->index('user_id');
            $table->index('status');
            $table->index('stage');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
