<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lead_stages', function (Blueprint $table) {
            $table->id();
            $table->string('name');

            $table->foreignId('parent_id')
                ->nullable()
                ->constrained('lead_stages')
                ->nullOnDelete();

            $table->foreignId('company_id')
                ->nullable()
                ->after('id') // optional: position
                ->constrained('companies')
                ->nullOnDelete();

            $table->integer('order')->default(0);
            $table->boolean('status')->default(true);
            $table->json('data')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lead_stages');
    }
};
