<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();

            // Add UUID column
            $table->uuid('uuid')->unique();

            $table->string('name');
            $table->string('phone', 20);
            $table->string('email')->nullable();
            $table->text('note')->nullable();
            $table->string('reference')->nullable();
            $table->string('portal')->nullable();

            $table->string('status')->default('new'); // new, contacted, won, lost

            $table->foreignId('stage_id')
                ->nullable()
                ->constrained('lead_stages')
                ->nullOnDelete();

            $table->string('portal_lead_id')->nullable();

            $table->foreignId('user_id')
                ->constrained()
                ->cascadeOnDelete();

            $table->foreignId('company_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            $table->json('data')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};

