<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;

class SuperAdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // 1️⃣ Create Super Admin role if it doesn't exist
        $role = Role::firstOrCreate(['name' => 'Super Admin']);

        // 2️⃣ Create default Super Admin user
        $user = User::firstOrCreate(
            ['email' => 'digitalyahiya@gmail.com'], // default email
            [
                'name' => 'Super Admin',
                'password' => Hash::make('Yahiya@3014'), // default password
            ]
        );

        // 3️⃣ Assign Super Admin role
        if (!$user->hasRole('Super Admin')) {
            $user->assignRole($role);
        }

        $this->command->info('Super Admin user created: digitalyahiya@gmail.com / Yahiya@3014');
    }
}
