@csrf

{{-- Slot & Schedule Info --}}
@if(isset($slot))
<div class="row mb-3">
    <div class="col-md-3">
        <label class="form-label">Schedule User</label>
        <input type="text" class="form-control" value="{{ $booking->slot->schedule->user->name ?? '-' }}" disabled>
    </div>
    <div class="col-md-3">
        <label class="form-label">Booked User</label>
        <input type="text" class="form-control" value="{{ $booking->slot->user->name ?? '-' }}" disabled>
    </div>
    <div class="col-md-3">
        <label class="form-label">Schedule Date</label>
        <input type="text" class="form-control" value="{{ $booking->slot->schedule->schedule_date ?? '-' }}" disabled>
    </div>
    <div class="col-md-3">
        <label class="form-label">Shift</label>
        <input type="text" class="form-control" value="{{ ucfirst($slot->shift) }}" disabled>
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-4">
        <label class="form-label">Location</label>
        <input type="text" class="form-control" value="{{ $slot->location }}" disabled>
    </div>
    <div class="col-md-2">
        <label class="form-label">Start Time</label>
        <input type="text" class="form-control" value="{{ \Carbon\Carbon::parse($slot->start_time)->format('H:i') }}" disabled>
    </div>
    <div class="col-md-2">
        <label class="form-label">End Time</label>
        <input type="text" class="form-control" value="{{ \Carbon\Carbon::parse($slot->end_time)->format('H:i') }}" disabled>
    </div>
    <div class="col-md-4">
        <label class="form-label">Slot Fees</label>
        <input type="text" class="form-control" value="{{ number_format($slot->fees, 2) }}" disabled>
    </div>
</div>

{{-- Hidden fields --}}
<input type="hidden" name="slot_id" value="{{ $slot->id }}">
<input type="hidden" name="user_id" value="{{ $scheduledUser->id ?? '' }}">
@endif

{{-- Customer Info --}}
<div class="row mb-3">
    <div class="col-md-6">
        <label class="form-label">Customer Name</label>
        <input type="text" name="customer_name" value="{{ old('customer_name') }}" class="form-control" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">Customer Phone</label>
        <input type="text" name="customer_phone" value="{{ old('customer_phone') }}" class="form-control" required>
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-6">
        <label class="form-label">Stage</label>
        <select name="stage" class="form-select">
            <option value="new" @selected(old('stage') == 'new')>New</option>
            <option value="follow_up" @selected(old('stage') == 'follow_up')>Follow Up</option>
            <option value="completed" @selected(old('stage') == 'completed')>Completed</option>
        </select>
    </div>
    <div class="col-md-6">
        <label class="form-label">Status</label>
        <select name="status" class="form-select">
            <option value="pending" @selected(old('status') == 'pending')>Pending</option>
            <option value="confirmed" @selected(old('status') == 'confirmed')>Confirmed</option>
            <option value="cancelled" @selected(old('status') == 'cancelled')>Cancelled</option>
            <option value="completed" @selected(old('status') == 'completed')>Completed</option>
        </select>
    </div>
</div>

{{-- Extra dynamic data --}}
<!-- <div class="row mb-3">
    <div class="col-md-12">
        <label class="form-label">Additional Data (JSON)</label>
        <textarea name="data" class="form-control" rows="3" placeholder='{"age":30,"notes":"Sample"}'>{{ old('data') }}</textarea>
    </div>
</div> -->

<div class="mb-3">
    <button class="btn btn-success">Save Booking</button>
    <a href="{{ route('admin.bookings.index') }}" class="btn btn-secondary">Cancel</a>
</div>
