@extends('layouts.app')

@section('title', 'Bookings')

@section('content')
<div class="container py-4">
    <div class="page-inner">

        <div class="row mb-3">
            <div class="col-md-8">
                <h3 class="fw-bold">Bookings</h3>
            </div>
            <div class="col-md-4 text-end">
                <a href="{{ route('admin.bookings.create') }}" class="btn btn-primary btn-sm mb-3">
                    <i class="bi bi-plus-circle"></i> Add Booking
                </a>
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body table-responsive">
                <table id="bookingsTable" class="table table-striped table-hover display">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Customer</th>
                            <th>Phone</th>
                            <th>Slot</th>
                            <th>User</th>
                            <th>Stage</th>
                            <th>Status</th>
                            <th width="150">Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th></th>
                            <th>Customer</th>
                            <th></th>
                            <th>Slot</th>
                            <th>User</th>
                            <th>Stage</th>
                            <th>Status</th>
                            <th></th>
                        </tr>
                    </tfoot>
                    <tbody>
                        @forelse($bookings as $booking)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $booking->customer_name }}</td>
                                <td>{{ $booking->customer_phone }}</td>
                                <td>
                                    {{ $booking->slot->shift ?? '-' }}<br>
                                    {{ $booking->slot->start_time ?? '-' }} - {{ $booking->slot->end_time ?? '-' }}<br>
                                    {{ $booking->slot->location ?? '-' }}
                                </td>
                                <td>{{ $booking->user->name ?? '-' }}</td>
                                <td>{{ ucfirst($booking->stage) }}</td>
                                <td>
                                    <span class="badge bg-{{ $booking->status == 'pending' ? 'secondary' : ($booking->status == 'confirmed' ? 'success' : ($booking->status == 'cancelled' ? 'danger' : 'info')) }}">
                                        {{ ucfirst($booking->status) }}
                                    </span>
                                </td>
                                <td class="d-flex gap-1">
                                    <a href="{{ route('admin.bookings.show', $booking) }}" class="btn btn-info btn-sm">View</a>
                                    <a href="{{ route('admin.bookings.edit', $booking) }}" class="btn btn-warning btn-sm">Edit</a>
                                    <form action="{{ route('admin.bookings.destroy', $booking) }}" method="POST" onsubmit="return confirm('Cancel this booking?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-danger btn-sm">Cancel</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center text-muted">No bookings found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <div class="mt-3">
            {{ $bookings->links() }}
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $("#bookingsTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            // Multi-column filter for Customer, Slot, Stage, Status
            this.api().columns([1,3,5,6]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^'+val+'$' : '', true, false).draw();
                    });
                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
@endsection
