@extends('layouts.app')

@section('title', 'Booking Details')

@section('content')
<div class="container py-4">
    <div class="page-inner">

        <div class="row mb-3">
            <div class="col-md-8">
                <h3 class="fw-bold">Booking Details</h3>
            </div>
            <div class="col-md-4 text-end">
                <a href="{{ route('admin.bookings.index') }}" class="btn btn-secondary btn-sm">Back to List</a>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <p><strong>Customer Name:</strong> {{ $booking->customer_name }}</p>
                <p><strong>Phone:</strong> {{ $booking->customer_phone }}</p>
                <p><strong>Reference:</strong> {{ $booking->customer_reference ?? '-' }}</p>
                <p><strong>Slot:</strong> {{ $booking->slot->shift ?? '-' }} ({{ $booking->slot->start_time ?? '-' }} - {{ $booking->slot->end_time ?? '-' }})</p>
                <p><strong>Location:</strong> {{ $booking->slot->location ?? '-' }}</p>
                <p><strong>User:</strong> {{ $booking->user->name ?? '-' }}</p>
                <p><strong>Stage:</strong> {{ ucfirst($booking->stage) }}</p>
                <p><strong>Status:</strong> {{ ucfirst($booking->status) }}</p>
                <p><strong>Extra Data:</strong> <pre>{{ json_encode($booking->data, JSON_PRETTY_PRINT) }}</pre></p>
                <p><strong>Created At:</strong> {{ $booking->created_at->format('Y-m-d H:i') }}</p>
                <p><strong>Updated At:</strong> {{ $booking->updated_at->format('Y-m-d H:i') }}</p>
            </div>
        </div>

    </div>
</div>
@endsection
