@csrf

<div class="row">
    <div class="col-md-6 mb-3">
        <label class="form-label">Name</label>
        <input name="name"
               value="{{ old('name', $category->name ?? '') }}"
               class="form-control"
               required>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label">Slug</label>
        <input name="slug"
               value="{{ old('slug', $category->slug ?? '') }}"
               class="form-control"
               required>
    </div>
</div>

<div class="row">
    <div class=" col-md-4 mb-3">
        <label class="form-label">Parent Category</label>
        <select name="parent_id" class="form-select form-control">
            <option value="">— None —</option>
            @foreach($parents as $parent)
                <option value="{{ $parent->id }}"
                    @selected(old('parent_id', $category->parent_id ?? '') == $parent->id)>
                    {{ $parent->name }}
                </option>
            @endforeach
        </select>
    </div>
    <div class="col-md-4 mb-3">
        <label class="form-label">Order</label>
        <input type="number"
               name="order"
               value="{{ old('order', $category->order ?? 0) }}"
               class="form-control">
    </div>

    <div class="col-md-4 mb-3">
        <label class="form-label">Status</label>
        <select name="status" class="form-select form-control">
            <option value="1" @selected(old('status', $category->status ?? 1) == 1)>Active</option>
            <option value="0" @selected(old('status', $category->status ?? 1) == 0)>Inactive</option>
        </select>
    </div>
</div>

<div class="mb-3">
    <label class="form-label">Icon</label>
    <input name="icon"
           value="{{ old('icon', $category->icon ?? '') }}"
           class="form-control">
</div>

<div class="mb-3">
    <label class="form-label">Short Description</label>
    <input name="short_description"
           value="{{ old('short_description', $category->short_description ?? '') }}"
           class="form-control">
</div>

<div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description"
              rows="4"
              class="form-control">{{ old('description', $category->description ?? '') }}</textarea>
</div>

<div class="mb-3">
    <label class="form-label">Meta (JSON)</label>
    <textarea name="meta"
              rows="3"
              class="form-control"
              placeholder='{"title":"SEO title","keywords":["a","b"]}'>{{ old('meta', isset($category->meta) ? json_encode($category->meta) : '') }}</textarea>
</div>

<!-- <button class="btn btn-success">
    Save Category
</button>
<a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">
    Cancel
</a> -->
