@extends('layouts.app')

@section('title', 'Categories')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3"> Categories</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('admin.categories.index') }}"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Categories</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('categories.create')
                    <a href="{{ route('admin.categories.create') }}" class="btn btn-primary btn-sm mb-3">
                        <i class="bi bi-plus-circle"></i> Add Category
                    </a>
                @endcan
            </div>
        </div>


        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body table-responsive">
                <table id="categoriesTable" class="table table-striped table-hover display">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Parent</th>
                            <th>Status</th>
                            <th>Order</th>
                            <th width="180">Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th></th>
                            <th>Name</th>
                            <th>Parent</th>
                            <th>Status</th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tfoot>
                    <tbody>
                        @forelse($categories as $category)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>
                                    <strong>{{ $category->name }}</strong>
                                    <br>
                                    <small class="text-muted">{{ $category->slug }}</small>
                                </td>
                                <td>{{ $category->parent?->name ?? '-' }}</td>
                                <td>
                                    <span class="badge bg-{{ $category->status ? 'success' : 'secondary' }}">
                                        {{ $category->status ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>{{ $category->order }}</td>
                                <td class="d-flex gap-1">
                                    @can('categories.edit')
                                        <a href="{{ route('admin.categories.edit', $category) }}"
                                           class="btn btn-sm btn-warning">Edit</a>
                                    @endcan
                                    @can('categories.delete')
                                        <form action="{{ route('admin.categories.destroy', $category) }}" method="POST"
                                              onsubmit="return confirm('Are you sure?')">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-sm btn-danger">Delete</button>
                                        </form>
                                    @endcan
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted">No categories found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $("#categoriesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            // Add multi-column filters: Name, Parent, Status
            this.api().columns([1,2,3]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^'+val+'$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
@endsection
