{{-- Company Form Fields --}}
<div class="mb-3">
    <label for="name" class="form-label">Company Name</label>
    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror"
           value="{{ old('name', $company->name ?? '') }}" required>
    @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="slug" class="form-label">Slug</label>
    <input type="text" name="slug" id="slug" class="form-control @error('slug') is-invalid @enderror"
           value="{{ old('slug', $company->slug ?? '') }}" placeholder="Optional, auto-generated from name">
    @error('slug')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="parent_id" class="form-label">Parent Company</label>
    <select name="parent_id" id="parent_id" class="form-select @error('parent_id') is-invalid @enderror">
        <option value="">-- None --</option>
        @foreach($parents as $parent)
            <option value="{{ $parent->id }}"
                {{ old('parent_id', $company->parent_id ?? '') == $parent->id ? 'selected' : '' }}>
                {{ $parent->name }}
            </option>
        @endforeach
    </select>
    @error('parent_id')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="email" class="form-label">Email</label>
    <input type="email" name="email" id="email" class="form-control @error('email') is-invalid @enderror"
           value="{{ old('email', $company->email ?? '') }}">
    @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="phone" class="form-label">Phone</label>
    <input type="text" name="phone" id="phone" class="form-control @error('phone') is-invalid @enderror"
           value="{{ old('phone', $company->phone ?? '') }}">
    @error('phone')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="website" class="form-label">Website</label>
    <input type="url" name="website" id="website" class="form-control @error('website') is-invalid @enderror"
           value="{{ old('website', $company->website ?? '') }}">
    @error('website')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="status" class="form-label">Status</label>
    <select name="status" id="status" class="form-select @error('status') is-invalid @enderror">
        <option value="1" {{ old('status', $company->status ?? 1) ? 'selected' : '' }}>Active</option>
        <option value="0" {{ old('status', $company->status ?? 1) == 0 ? 'selected' : '' }}>Inactive</option>
    </select>
    @error('status')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="short_description" class="form-label">Short Description</label>
    <textarea name="short_description" id="short_description"
              class="form-control @error('short_description') is-invalid @enderror" rows="2">{{ old('short_description', $company->short_description ?? '') }}</textarea>
    @error('short_description')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="description" class="form-label">Description</label>
    <textarea name="description" id="description"
              class="form-control @error('description') is-invalid @enderror" rows="5">{{ old('description', $company->description ?? '') }}</textarea>
    @error('description')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="logo" class="form-label">Logo</label>
    <input type="file" name="logo" id="logo" class="form-control @error('logo') is-invalid @enderror">
    @if(!empty($company->logo))
        <img src="{{ asset($company->logo) }}" alt="Logo" class="img-thumbnail mt-2" style="max-width: 120px;">
    @endif
    @error('logo')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="banner" class="form-label">Banner</label>
    <input type="file" name="banner" id="banner" class="form-control @error('banner') is-invalid @enderror">
    @if(!empty($company->banner))
        <img src="{{ asset($company->banner) }}" alt="Banner" class="img-thumbnail mt-2" style="max-width: 200px;">
    @endif
    @error('banner')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="mb-3">
    <label for="order" class="form-label">Order</label>
    <input type="number" name="order" id="order" class="form-control @error('order') is-invalid @enderror"
           value="{{ old('order', $company->order ?? 0) }}">
    @error('order')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>
