@extends('layouts.app')

@section('title', 'Companies')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid mb-3">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Companies</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator">
                            <i class="icon-arrow-right"></i>
                        </li>
                        <li class="nav-item">
                            <a href="#">Companies</a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 ms-auto">
                @can('companies.create')
                    <a href="{{ route('admin.companies.create') }}" class="btn btn-sm btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Add Company
                    </a>
                @endcan
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="companiesTable" class="table table-striped table-hover display">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Slug</th>
                                <th>Status</th>
                                <th>Order</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Slug</th>
                                <th>Status</th>
                                <th>Order</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @forelse($companies as $company)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $company->name }}</td>
                                    <td>{{ $company->slug }}</td>
                                    <td>{{ $company->status ? 'Active' : 'Inactive' }}</td>
                                    <td>{{ $company->order ?? '-' }}</td>
                                    <td class="d-flex gap-1">
                                        @can('companies.edit')
                                            <a href="{{ route('admin.companies.edit', $company) }}" class="btn btn-sm btn-warning">
                                                Edit
                                            </a>
                                        @endcan

                                        @can('companies.delete')
                                            <form action="{{ route('admin.companies.destroy', $company) }}" method="POST" onsubmit="return confirm('Are you sure?');">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-sm btn-danger">
                                                    Delete
                                                </button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">No companies found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $("#companiesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([1, 2, 3]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
@endsection
