@php
    $authUser  = auth()->user();
    $companyId = optional($authUser->profile)->company_id;
@endphp

<div class="row">
    {{-- Name --}}
    <div class="col-md-4 mb-3">
        <label class="form-label">Name</label>
        <input type="text"
               name="name"
               value="{{ old('name', $stage->name ?? '') }}"
               class="form-control"
               required>
    </div>

    {{-- Parent Stage --}}
    <div class="col-md-4 mb-3">
        <label class="form-label">Parent Stage</label>
        <select name="parent_id" class="form-select form-control">
            <option value="">None</option>
            @foreach($parents as $parent)
                <option value="{{ $parent->id }}"
                    @selected(old('parent_id', $stage->parent_id ?? '') == $parent->id)>
                    {{ $parent->name }}
                </option>
            @endforeach
        </select>
    </div>

    {{-- Company --}}
    <div class="col-md-4 mb-3">
        <label class="form-label">Company</label>

        {{-- 🔐 Super Admin can change company --}}
        @can('leadstages.view.all')
            <select name="company_id" class="form-select form-control">
                <option value="">-- Select Company --</option>
                @foreach(\App\Models\Company::orderBy('name')->get() as $company)
                    <option value="{{ $company->id }}"
                        @selected(old('company_id', $stage->company_id ?? '') == $company->id)>
                        {{ $company->name }}
                    </option>
                @endforeach
            </select>
        @else
            {{-- 🔒 Company user: locked --}}
            <input type="text"
                   class="form-control"
                   value="{{ $stage->company->name ?? $authUser->profile->company->name ?? '-' }}"
                   readonly>

            <input type="hidden"
                   name="company_id"
                   value="{{ old('company_id', $stage->company_id ?? $companyId) }}">
        @endcan
    </div>

    {{-- Order --}}
    <div class="col-md-6 mb-3">
        <label class="form-label">Order</label>
        <input type="number"
               name="order"
               value="{{ old('order', $stage->order ?? 0) }}"
               class="form-control">
    </div>

    {{-- Status --}}
    <div class="col-md-6 mb-3">
        <label class="form-label">Status</label>
        <select name="status" class="form-select form-control">
            <option value="1" @selected(old('status', $stage->status ?? 1) == 1)>Active</option>
            <option value="0" @selected(old('status', $stage->status ?? 1) == 0)>Inactive</option>
        </select>
    </div>
</div>

<div class="text-end">
    <button type="submit" class="btn btn-primary">Save</button>
    <a href="{{ route('admin.lead-stages.index') }}" class="btn btn-secondary">Cancel</a>
</div>
