@extends('layouts.app')

@section('title', 'Lead Stages')

@section('content')
<div class="container">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Lead Stages</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Lead Stages</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('leadstages.create')
                    <a href="{{ route('admin.lead-stages.create') }}" class="btn btn-sm btn-primary mb-3">
                        Add Stage
                    </a>
                @endcan
            </div>
        </div>

        {{-- Table --}}
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="leadStagesTable" class="display table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Parent</th>
                                <th>Order</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>Name</th>
                                <th>Parent</th>
                                <th>Order</th>
                                <th>Status</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @forelse($stages as $stage)
                                <tr>
                                    <td>{{ $stage->name }}</td>
                                    <td>{{ optional($stage->parent)->name ?? '-' }}</td>
                                    <td>{{ $stage->order }}</td>
                                    <td>
                                        <span class="badge {{ $stage->status ? 'badge-success' : 'badge-secondary' }}">
                                            {{ $stage->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        @can('leadstages.edit')
                                            <a href="{{ route('admin.lead-stages.edit', $stage) }}"
                                               class="btn btn-sm btn-warning mb-1">
                                                Edit
                                            </a>
                                        @endcan

                                        @can('leadstages.delete')
                                            <form action="{{ route('admin.lead-stages.destroy', $stage) }}"
                                                  method="POST" style="display:inline-block">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-sm btn-danger mb-1"
                                                    onclick="return confirm('Delete this stage?')">
                                                    Delete
                                                </button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">No stages found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function () {
    $("#leadStagesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([0,1,3]).every(function () {
                var column = this;
                var select = $('<select class="form-select"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function (d) {
                    if (d) {
                        var text = d.replace(/<[^>]*>/g, '');
                        select.append('<option value="'+text+'">'+text+'</option>');
                    }
                });
            });
        }
    });
});
</script>
@endsection
