<!-- @extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between mb-3">
        <h4 class="fw-bold">Lead Stages – Kanban</h4>

        @can('leadstages.create')
            <a href="{{ route('admin.lead-stages.create') }}" class="btn btn-primary">
                + Add Stage
            </a>
        @endcan
    </div>

    <div class="row flex-nowrap overflow-auto">

        @foreach($stages as $stage)
            <div class="col-md-3">
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-dark text-white">
                        <strong>{{ $stage->name }}</strong>
                    </div>

                    <div class="card-body p-2 kanban-column">

                        @forelse($stage->children as $child)
                            <div class="card mb-2">
                                <div class="card-body p-2">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span>{{ $child->name }}</span>

                                        <div class="btn-group btn-group-sm">
                                            @can('leadstages.edit')
                                                <a href="{{ route('admin.lead-stages.edit', $child) }}"
                                                   class="btn btn-outline-secondary">
                                                    ✏️
                                                </a>
                                            @endcan

                                            @can('leadstages.delete')
                                                <form method="POST"
                                                      action="{{ route('admin.lead-stages.destroy', $child) }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-outline-danger"
                                                        onclick="return confirm('Delete this stage?')">
                                                        🗑️
                                                    </button>
                                                </form>
                                            @endcan
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-muted text-center small p-2">
                                No stages
                            </div>
                        @endforelse

                    </div>
                </div>
            </div>
        @endforeach

    </div>
</div>
@endsection -->
