@php
    $authUser = auth()->user();
@endphp

<div class="row">
    {{-- Name --}}
    <div class="col-md-4 mb-3">
        <label>Name</label>
        <input type="text" name="name" class="form-control"
               value="{{ old('name', $lead->name ?? '') }}" required>
    </div>

    {{-- Phone --}}
    <div class="col-md-4 mb-3">
        <label>Phone</label>
        <input type="text" name="phone" class="form-control"
               value="{{ old('phone', $lead->phone ?? '') }}" required>
    </div>

    {{-- Email --}}
    <div class="col-md-4 mb-3">
        <label>Email</label>
        <input type="email" name="email" class="form-control"
               value="{{ old('email', $lead->email ?? '') }}">
    </div>

    {{-- Reference --}}
    <div class="col-md-3 mb-3">
        <label>Reference</label>
        <input type="text" name="reference" class="form-control"
               value="{{ old('reference', $lead->reference ?? '') }}">
    </div>

    {{-- Stage --}}
    <div class="col-md-3 mb-3">
        <label>Stage</label>
        @can('leads.change_stage')
            <select name="stage_id" class="form-select">
                <option value="">-- Select Stage --</option>
                @foreach($stages as $stage)
                    <option value="{{ $stage->id }}"
                        @selected(old('stage_id', $lead->stage_id ?? '') == $stage->id)>
                        {{ $stage->name }}
                    </option>
                @endforeach
            </select>
        @else
            <input type="text" class="form-control" value="{{ $lead->stage->name ?? '-' }}" readonly>
            <input type="hidden" name="stage_id" value="{{ $lead->stage_id ?? '' }}">
        @endcan
    </div>

    {{-- User --}}
    <div class="col-md-3 mb-3">
        <label>User</label>
        @can('leads.change_user')
            <select name="user_id" class="form-select">
                <option value="">-- Select User --</option>
                @foreach($users as $user)
                    <option value="{{ $user->id }}"
                        @selected(old('user_id', $lead->user_id ?? '') == $user->id)>
                        {{ $user->name }}
                    </option>
                @endforeach
            </select>
        @else
            <input type="text" class="form-control"
                   value="{{ $lead->user->name ?? $authUser->name }}" readonly>
            <input type="hidden" name="user_id" value="{{ $lead->user_id ?? $authUser->id }}">
        @endcan
    </div>

    {{-- Portal --}}
    <div class="col-md-3 mb-3">
        <label>Portal</label>
        <input type="text" name="portal" class="form-control"
               value="{{ old('portal', $lead->portal ?? '') }}">
    </div>

    {{-- Note --}}
    <div class="col-md-12 mb-3">
        <label>Note</label>
        <textarea name="note" class="form-control" rows="3">{{ old('note', $lead->note ?? '') }}</textarea>
    </div>

    {{-- Submit Button --}}
    <div class="col-md-12 text-end">
        <button class="btn btn-primary">Save Lead</button>
    </div>
</div>
