@extends('layouts.app')

@section('title', 'Create Lead')

@section('content')
<div class="container">
    <div class="page-inner">
        <div class="row mb-3">
            <div class="col-md-8">
                <h3 class="fw-bold">Create Lead</h3>
            </div>
            <div class="col-md-4 text-end">
                <a href="{{ route('admin.leads.index') }}" class="btn btn-sm btn-secondary">
                    Back
                </a>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <form method="POST" action="{{ route('admin.leads.store') }}">
                    @csrf

                    {{-- Include form partial --}}
                    @include('leads._form', ['lead' => null, 'users' => $users, 'stages' => $stages])

                    <div class="mt-3">
                        <button type="submit" class="btn btn-sm btn-primary">
                            Create Lead
                        </button>
                        <a href="{{ route('admin.leads.index') }}" class="btn btn-sm btn-secondary">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
