@extends('layouts.app')

@section('title', 'Edit Lead')

@section('content')
<div class="container">
    <div class="page-inner">
        <div class="row mb-3">
            <div class="col-md-8">
                <h3 class="fw-bold">Edit Lead</h3>
            </div>
            <div class="col-md-4 text-end">
                <a href="{{ route('admin.leads.index') }}" class="btn btn-sm btn-secondary">
                    Back
                </a>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <form method="POST" action="{{ route('admin.leads.update', $lead) }}">
                    @csrf
                    @method('PUT')

                    {{-- Include form partial --}}
                    @include('leads._form', ['lead' => $lead, 'users' => $users, 'stages' => $stages])

                    <div class="mt-3">
                        <button type="submit" class="btn btn-sm btn-primary">
                            Update Lead
                        </button>
                        <a href="{{ route('admin.leads.index') }}" class="btn btn-sm btn-secondary">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
