@extends('layouts.app')

@section('title', 'Edit Location')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                <h3 class="fw-bold mb-3">Create Location</h3>
                <ul class="breadcrumbs mb-3">
                    <li class="nav-home">
                        <a href="{{ route('dashboard') }}">
                            <i class="icon-home"></i>
                        </a>
                    </li>
                    <li class="separator">
                        <i class="icon-arrow-right"></i>
                    </li>
                    <li class="nav-item">
                        <a href="#">Locations</a>
                    </li>
                </ul>
                </div>
            </div>
            <div class="col-md-4 ms-auto">

                @can('locations.view')
                <a href="{{ route('admin.locations.index') }}" class="btn btn-sm btn-primary mb-3">
                    Locations
                </a>
                @endcan
            </div>
        </div>
        <div class="card">
            <div class="card-body">

                <form action="{{ route('admin.locations.update', $location) }}" method="POST">
                    @csrf
                    @method('PUT')

                    @include('locations._form', ['location' => $location])

                    <div class="mt-3">
                        <button class="btn btn-primary">Update Location</button>
                        <a href="{{ route('admin.locations.index') }}" class="btn btn-secondary">
                            Cancel
                        </a>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection
