@extends('layouts.app')

@section('title', 'Edit Permission')

@section('content')
<div class="container">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Edit Permission</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator">
                            <i class="icon-arrow-right"></i>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.permissions.index') }}">Permissions</a>
                        </li>
                        <li class="separator">
                            <i class="icon-arrow-right"></i>
                        </li>
                        <li class="nav-item">
                            <a href="#">Edit Permission</a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('permissions.view')
                    <a href="{{ route('admin.permissions.index') }}" class="btn btn-sm btn-secondary mb-3">
                        Back to Permissions
                    </a>
                @endcan
            </div>
        </div>

        {{-- Display validation errors --}}
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Edit Permission Form --}}
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.permissions.update', $permission) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="mb-3">
                        <label class="form-label">Permission Name</label>
                        <input type="text" name="name" class="form-control" 
                               value="{{ old('name', $permission->name) }}" 
                               placeholder="Enter permission name" required>
                    </div>

                    <button type="submit" class="btn btn-primary">Update Permission</button>
                    <a href="{{ route('admin.permissions.index') }}" class="btn btn-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
