@extends('layouts.app')

@section('title', 'Permissions')

@section('content')
<div class="container">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Permissions</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Permissions</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('manage permissions')
                    <a href="{{ route('admin.permissions.create') }}" class="btn btn-sm btn-primary mb-3">
                        Add Permission
                    </a>
                @endcan
            </div>
        </div>

        {{-- Permissions Table --}}
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="multi-filter-permissions" class="display table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Permission Name</th>
                                <th>Group</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>Permission Name</th>
                                <th>Group</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @forelse($permissions as $permission)
                                <tr>
                                    <td><span class="badge badge-pill badge-success">{{ $permission->name }}</span></td>
                                    <td>{{ \Illuminate\Support\Str::before($permission->name, '.') }}</td>
                                    <td>
                                        {{-- Edit Button --}}
                                        @can('permissions.edit')
                                            <a href="{{ route('admin.permissions.edit', $permission) }}" class="btn btn-sm btn-warning mb-1">
                                                Edit
                                            </a>
                                        @endcan

                                        {{-- Delete Button --}}
                                        @can('permissions.delete')
                                            <form action="{{ route('admin.permissions.destroy', $permission) }}" method="POST" style="display:inline-block">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger mb-1"
                                                    onclick="return confirm('Are you sure you want to delete this permission?')">
                                                    Delete
                                                </button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center">No permissions found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function () {
    $("#multi-filter-permissions").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([0,1]).every(function () {
                var column = this;
                var select = $('<select class="form-select"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function (d) {
                    if(d){
                        var text = d.replace(/<[^>]*>/g, ''); // strip HTML
                        select.append('<option value="'+text+'">'+text+'</option>')
                    }
                });
            });
        }
    });
});
</script>
@endsection
