<div class="mb-3">
    <label class="form-label">Pipeline Name</label>
    <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
        value="{{ old('name', $pipeline->name ?? '') }}" required>
    @error('name')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-3">
    <label class="form-label">Default Stage</label>
    <select name="stage_id" class="form-select @error('stage_id') is-invalid @enderror">
        <option value="">-- Select Stage --</option>
        @foreach($stages as $stage)
            <option value="{{ $stage->id }}" {{ old('stage_id', $pipeline->stage_id ?? '') == $stage->id ? 'selected' : '' }}>
                {{ $stage->name }}
            </option>
        @endforeach
    </select>
    @error('stage_id')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-3">
    <label class="form-label">Status</label>
    <select name="status" class="form-select @error('status') is-invalid @enderror">
        <option value="1" {{ old('status', $pipeline->status ?? 1) == 1 ? 'selected' : '' }}>Active</option>
        <option value="0" {{ old('status', $pipeline->status ?? 1) == 0 ? 'selected' : '' }}>Inactive</option>
    </select>
    @error('status')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="d-flex justify-content-end gap-2">
    <a href="{{ route('pipelines.index') }}" class="btn btn-secondary">Cancel</a>
    <button class="btn btn-primary">Save</button>
</div>
