@extends('layouts.app')

@section('title', 'Pipelines')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid mb-3">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Pipelines</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Pipelines</a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 ms-auto">
                @can('pipelines.create')
                    <a href="{{ route('pipelines.create') }}" class="btn btn-sm btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Add Pipeline
                    </a>
                @endcan
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="pipelinesTable" class="table table-striped table-hover display">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Default Stage</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Default Stage</th>
                                <th>Status</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @forelse($pipelines as $pipeline)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $pipeline->name }}</td>
                                    <td>{{ $pipeline->stage?->name ?? '-' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $pipeline->status ? 'success' : 'secondary' }}">
                                            {{ $pipeline->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td class="d-flex gap-1">
                                        @can('pipelines.edit')
                                            <a href="{{ route('pipelines.edit', $pipeline) }}" class="btn btn-sm btn-warning">
                                                Edit
                                            </a>
                                        @endcan
                                        @can('pipelines.delete')
                                            <form action="{{ route('pipelines.destroy', $pipeline) }}" method="POST" onsubmit="return confirm('Are you sure?');">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-sm btn-danger">Delete</button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">No pipelines found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="mt-3">
            {{ $pipelines->links() }}
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $("#pipelinesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([1,2,3]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
@endsection
