<section>
    <header class="mb-4">
        <h5 class="fw-semibold">Profile Information</h5>
        <p class="text-muted">
            Update your account's profile information, contact info, and social links.
        </p>
    </header>

    {{-- Email Verification --}}
    <form id="send-verification" method="post" action="{{ route('verification.send') }}">
        @csrf
    </form>

    <form method="post" action="{{ route('profile.update') }}" enctype="multipart/form-data">
        @csrf
        @method('patch')

        {{-- Name --}}
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input
                id="name"
                name="name"
                type="text"
                class="form-control @error('name') is-invalid @enderror"
                value="{{ old('name', $user->name) }}"
                required
            >
            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        {{-- Email --}}
        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input
                id="email"
                name="email"
                type="email"
                class="form-control @error('email') is-invalid @enderror"
                value="{{ old('email', $user->email) }}"
                required
            >
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror

            @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                <div class="alert alert-warning mt-3">
                    <p class="mb-1">Your email address is unverified.</p>
                    <button type="submit" form="send-verification" class="btn btn-link p-0">
                        Click here to re-send the verification email.
                    </button>
                    @if (session('status') === 'verification-link-sent')
                        <div class="text-success mt-2">
                            A new verification link has been sent to your email address.
                        </div>
                    @endif
                </div>
            @endif
        </div>

        {{-- Avatar & Banner --}}
        <div class="mb-3">
            <label for="avatar" class="form-label">Avatar</label>
            <input type="file" id="avatar" name="avatar" class="form-control @error('avatar') is-invalid @enderror">
            @error('avatar')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="banner" class="form-label">Banner</label>
            <input type="file" id="banner" name="banner" class="form-control @error('banner') is-invalid @enderror">
            @error('banner')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        {{-- Contact Info --}}
        <div class="mb-3">
            <label for="phone" class="form-label">Phone</label>
            <input id="phone" name="phone" type="text" class="form-control" value="{{ old('phone', $user->profile->phone ?? '') }}">
        </div>

        <div class="mb-3">
            <label for="website" class="form-label">Website</label>
            <input id="website" name="website" type="url" class="form-control" value="{{ old('website', $user->profile->website ?? '') }}">
        </div>

        {{-- Position & Department --}}
        <div class="row mb-3">
            <div class="col">
                <label for="position" class="form-label">Position</label>
                <input id="position" name="position" type="text" class="form-control" value="{{ old('position', $user->profile->position ?? '') }}">
            </div>
            <div class="col">
                <label for="department" class="form-label">Department</label>
                <input id="department" name="department" type="text" class="form-control" value="{{ old('department', $user->profile->department ?? '') }}">
            </div>
        </div>

        {{-- Social Media --}}
        <div class="mb-3">
            <label for="linkedin" class="form-label">LinkedIn</label>
            <input id="linkedin" name="linkedin" type="url" class="form-control" value="{{ old('linkedin', $user->profile->linkedin ?? '') }}">
        </div>
        <div class="mb-3">
            <label for="facebook" class="form-label">Facebook</label>
            <input id="facebook" name="facebook" type="url" class="form-control" value="{{ old('facebook', $user->profile->facebook ?? '') }}">
        </div>
        <div class="mb-3">
            <label for="instagram" class="form-label">Instagram</label>
            <input id="instagram" name="instagram" type="url" class="form-control" value="{{ old('instagram', $user->profile->instagram ?? '') }}">
        </div>
        <div class="mb-3">
            <label for="twitter" class="form-label">Twitter</label>
            <input id="twitter" name="twitter" type="url" class="form-control" value="{{ old('twitter', $user->profile->twitter ?? '') }}">
        </div>

        {{-- Languages & Locations --}}
        <div class="row mb-3">
            <div class="col">
                <label for="languages" class="form-label">Languages (comma separated)</label>
                <input id="languages" name="languages" type="text" class="form-control" value="{{ old('languages', isset($user->profile->languages) ? implode(',', $user->profile->languages) : '') }}">
            </div>
            <div class="col">
                <label for="locations" class="form-label">Locations (comma separated)</label>
                <input id="locations" name="locations" type="text" class="form-control" value="{{ old('locations', isset($user->profile->locations) ? implode(',', $user->profile->locations) : '') }}">
            </div>
        </div>

        {{-- About --}}
        <div class="mb-3">
            <label for="about" class="form-label">About / Bio</label>
            <textarea id="about" name="about" class="form-control" rows="4">{{ old('about', $user->profile->about ?? '') }}</textarea>
        </div>

        {{-- Submit --}}
        <div class="d-flex align-items-center gap-3">
            <button type="submit" class="btn btn-primary">Save</button>

            @if (session('status') === 'profile-updated')
                <span class="text-success">Saved.</span>
            @endif
        </div>
    </form>
</section>
