@extends('layouts.app')
@section('content')
<div class="container mt-4">
   <div class="profile-header text-center position-relative">
      {{-- Banner --}}
      @if($user->profile->banner)
      <div class="banner mb-5">
         <img src="{{ asset('storage/' . $user->profile->banner) }}" 
            alt="Banner" class="img-fluid w-100 rounded-top" style="height:200px; object-fit:cover;">
      </div>
      @else
      <div class="banner mb-5 bg-secondary rounded-top" style="height:200px;"></div>
      @endif
   </div>
   {{-- Stats / Info Grid --}}
   <div class="row justify-content-center mb-4">
      <div class="col-md-8">
         <div class="row py-3 align-items-center">
            <div class="col-md-3">
               {{-- Avatar --}}
               <div>
                  @if($user->profile->avatar)
                  <img src="{{ asset('storage/' . $user->profile->avatar) }}" 
                     alt="Avatar" class="avatar-img rounded-circle p-3" >
                  @else
                  <div class="rounded-circle bg-light border border-white d-flex align-items-center justify-content-center w-100 h-100" style="width:120px; height:120px;"
                     >
                     <i class="fas fa-user fa-2x text-muted"></i>
                  </div>
                  @endif
               </div>
            </div>
            <div class="col-md-7">
               {{-- User Info --}}
               <div class="">
                  <h3 class="fw-bold">{{ $user->name }}</h3>
                  <p class="text-muted mb-2">{{ $user->profile->position ?? '—' }} @if($user->profile->department) | {{ $user->profile->department }} @endif</p>
                  <p class="bio">{{ $user->profile->about ?? '—' }}</p>
               </div>
            </div>
            <div class="col-md-2">
               {{-- Action Button --}}
               <div class="text-center ">
                  <a href="{{ route('profile.edit') }}" class="btn btn-primary btn-sm">Edit Profile</a>
               </div>
            </div>
         </div>
         <div class="card shadow-sm">
            <div class="card-body">
               <div class="row ">
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Email</strong>
                     <p>{{ $user->email }}</p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Company</strong>
                     <p>{{ $user->profile->company->name ?? '—' }}</p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Reports To</strong>
                     <p>{{ $user->profile->reportsTo->name ?? '—' }}</p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Phone</strong>
                     <p>{{ $user->profile->phone ?? '—' }}</p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Website</strong>
                     <p>
                        @if($user->profile->website)
                        <a href="{{ $user->profile->website }}" target="_blank">{{ $user->profile->website }}</a>
                        @else
                        —
                        @endif
                     </p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Roles</strong>
                     <p>{{ implode(', ', $user->getRoleNames()->toArray()) }}</p>
                  </div>
               </div>
               <!-- row -->
            </div>
            <!-- card-body -->
         </div>
         <!-- card -->
      </div>
   </div>
</div>
<style>
   /* Instagram-like bio styling */
   .bio {
   font-size: 0.95rem;
   color: #555;
   max-width: 600px;
   margin: 0 auto;
   }
   /* Make avatar overlap banner */
   .profile-header .avatar {
   transform: translateY(-50%);
   }
</style>
@endsection