@extends('layouts.app')

@section('title', 'Add Property Developer')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid mb-3">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Add Property Developer</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="{{ route('admin.property_developers.index') }}">Property Developers</a></li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Add Developer</a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 ms-auto">
                <a href="{{ route('admin.property_developers.index') }}" class="btn btn-sm btn-secondary mb-3">
                    Back to Developers
                </a>
            </div>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.property_developers.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    @include('property_developers._form', ['propertyDeveloper' => null])

                    <div class="mt-3">
                        <button class="btn btn-primary">Save Developer</button>
                        <a href="{{ route('admin.property_developers.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
