@extends('layouts.app')

@section('title', 'Property Developers')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid mb-3">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Property Developers</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Property Developers</a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 ms-auto">
                @can('property_developers.create')
                    <a href="{{ route('admin.property_developers.create') }}" class="btn btn-sm btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Add Developer
                    </a>
                @endcan
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="developersTable" class="table table-striped table-hover display">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Short Description</th>
                                <th>Status</th>
                                <th>Order</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Short Description</th>
                                <th>Status</th>
                                <th>Order</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @forelse($developers as $developer)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $developer->name }}</td>
                                    <td>{{ $developer->short_description }}</td>
                                    <td>
                                        <span class="badge bg-{{ $developer->status ? 'success' : 'secondary' }}">
                                            {{ $developer->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>{{ $developer->order }}</td>
                                    <td class="d-flex gap-1">
                                        @can('property_developers.edit')
                                            <a href="{{ route('admin.property_developers.edit', $developer) }}" class="btn btn-sm btn-warning">
                                                Edit
                                            </a>
                                        @endcan
                                        @can('property_developers.delete')
                                            <form action="{{ route('admin.property_developers.destroy', $developer) }}" method="POST" onsubmit="return confirm('Are you sure?');">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-sm btn-danger">Delete</button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">No property developers found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="mt-3">
            {{ $developers->links() }}
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $("#developersTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([1,2,3]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
@endsection
