@extends('layouts.app')

@section('content')
<div class="container">
   <div class="page-inner">
      <div class="row row-demo-grid">
         <div class="col-md-8">
            <div class="page-header">
               <h3 class="fw-bold mb-3">Roles</h3>
               <ul class="breadcrumbs mb-3">
                  <li class="nav-home">
                     <a href="{{ route('dashboard') }}">
                        <i class="icon-home"></i>
                     </a>
                  </li>
                  <li class="separator">
                     <i class="icon-arrow-right"></i>
                  </li>
                  <li class="nav-item">
                     <a href="#">Roles</a>
                  </li>
               </ul>
            </div>
         </div>
         <div class="col-md-4 ms-auto">
            @can('manage roles')
            <a href="{{ route('admin.roles.create') }}" class="btn btn-sm btn-primary mb-3">
                Add Role
            </a>
            @endcan
         </div>
      </div>

      @if(session('success'))
      <div class="alert alert-success">
         {{ session('success') }}
      </div>
      @endif

      <div class="card">
         <div class="card-body">
            <div class="table-responsive">
               <table id="multi-filter-select" class="display table table-striped table-hover">
                  <thead>
                     <tr>
                        <th>Role Name</th>
                        <th>Permissions</th>
                        <th>Actions</th>
                     </tr>
                  </thead>
                  <tfoot>
                     <tr>
                        <th>Role Name</th>
                        <th>Permissions</th>
                        <th></th>
                     </tr>
                  </tfoot>
                  <tbody>
                     @forelse($roles as $role)
                     <tr>
                        <td>{{ $role->name }}</td>
                        <td>
                            {!! implode(' ', $role->permissions->pluck('name')->map(function($name) {
                                return '<span class="badge badge-pill badge-info">' . $name . '</span>';
                            })->toArray()) !!}
                        </td>
                        <td>
                           {{-- Edit Button --}}
                           @can('roles.edit')
                              <a href="{{ route('admin.roles.edit', $role) }}" class="btn btn-sm btn-warning mb-1">
                                    Edit
                              </a>
                           @endcan

                           {{-- Delete Button --}}
                           @can('roles.delete')
                              <form action="{{ route('admin.roles.destroy', $role) }}" method="POST" style="display:inline-block">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger mb-1"
                                       onclick="return confirm('Are you sure you want to delete this role?')">
                                       Delete
                                    </button>
                              </form>
                           @endcan
                        </td>
                     </tr>
                     @empty
                     <tr>
                        <td colspan="3" class="text-center">No roles found.</td>
                     </tr>
                     @endforelse
                  </tbody>
               </table>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection

@section('scripts')
<script>
   $(document).ready(function () {
       $("#multi-filter-select").DataTable({
           pageLength: 10,
           initComplete: function () {
               this.api().columns([0, 1]).every(function () {
                   var column = this;

                   var select = $('<select class="form-select"><option value="">All</option></select>')
                       .appendTo($(column.footer()).empty())
                       .on("change", function () {
                           var val = $.fn.dataTable.util.escapeRegex($(this).val());
                           column
                               .search(val ? "^" + val + "$" : "", true, false)
                               .draw();
                       });

                   column.data().unique().sort().each(function (d) {
                       if (d) {
                           select.append('<option value="' + d + '">' + d + '</option>');
                       }
                   });
               });
           }
       });
   });
</script>
@endsection
