@php
use App\Models\Schedule;
$authUser = auth()->user();
$schedule = $schedule ?? new Schedule();
@endphp
{{-- ================= BASIC INFORMATION ================= --}}
<div class="card mb-4">
   <div class="card-header fw-bold">Basic Information</div>
   <div class="card-body">
      <div class="row">
         {{-- ================= USER ================= --}}
         <div class="col-md-6 mb-3">
            <label class="form-label">User</label>
            @can('schedules.change.user')
            <select name="user_id" class="form-select form-control" required>
               <option value="">-- Select User --</option>
               @foreach($users as $user)
               <option value="{{ $user->id }}"
               {{ old('user_id', $schedule->user_id) == $user->id ? 'selected' : '' }}>
               {{ $user->name }}
               </option>
               @endforeach
            </select>
            @else
            <input type="text" class="form-control"
               value="{{ $schedule->user->name ?? $authUser->name }}" readonly>
            <input type="hidden" name="user_id"
               value="{{ $schedule->user_id ?? $authUser->id }}">
            @endcan
         </div>
         {{-- ================= COMPANY ================= --}}
         <div class="col-md-6 mb-3">
            <label class="form-label">Company</label>
            @can('schedules.change.company')
            <select name="company_id" class="form-select form-control" required>
               <option value="">-- Select Company --</option>
               @foreach($companies as $company)
               <option value="{{ $company->id }}"
               {{ old('company_id', $schedule->company_id) == $company->id ? 'selected' : '' }}>
               {{ $company->name }}
               </option>
               @endforeach
            </select>
            @else
            <input type="text" class="form-control"
               value="{{ $schedule->company->name ?? $authUser->profile->company->name ?? '' }}" readonly>
            <input type="hidden" name="company_id"
               value="{{ $schedule->company_id ?? $authUser->profile->company_id }}">
            @endcan
         </div>
      </div>
      <div class="row">
         {{-- Schedule Date --}}
         <div class="col-md-3 mb-3">
            <label class="form-label">Schedule Date</label>
            <input type="date" name="schedule_date" class="form-control"
               value="{{ old('schedule_date', optional($schedule->schedule_date)->format('Y-m-d')) }}"
               required>
         </div>
         {{-- Per Customer Time --}}
         <div class="col-md-3 mb-3">
            <label class="form-label">Per Customer Time (mins)</label>
            <input type="number" name="per_customer_time" class="form-control"
               value="{{ old('per_customer_time', $schedule->per_customer_time ?? 30) }}">
         </div>
         {{-- Fees --}}
         <div class="col-md-3 mb-3">
            <label class="form-label">Fees</label>
            <input type="number" step="0.01" name="fees" class="form-control"
               value="{{ old('fees', $schedule->fees ?? 0) }}">
         </div>
         {{-- Status --}}
         <div class="col-md-3 mb-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select form-control">
            <option value="1" {{ old('status', $schedule->status ?? 1) == 1 ? 'selected' : '' }}>
            Active
            </option>
            <option value="0" {{ old('status', $schedule->status ?? 1) == 0 ? 'selected' : '' }}>
            Inactive
            </option>
            </select>
         </div>
      </div>
   </div>
</div>
<div class="row">
   <div class="col-md-6">
      {{-- ================= MORNING SHIFT ================= --}}
      <div class="card mb-4">
         <div class="card-header fw-bold">Morning Shift</div>
         <div class="card-body">
            <div class="mb-3">
               <label class="form-label">Location</label>
               <input type="text" name="morning_location" class="form-control"
                  value="{{ old('morning_location', $schedule->morning_location) }}" required>
            </div>
            <div class="row">
               <div class="col-md-6 mb-3">
                  <label class="form-label">Start Time</label>
                  <input type="time" name="morning_start_time" class="form-control"
                     value="{{ old('morning_start_time', $schedule->morning_start_time) }}" required>
               </div>
               <div class="col-md-6 mb-3">
                  <label class="form-label">End Time</label>
                  <input type="time" name="morning_end_time" class="form-control"
                     value="{{ old('morning_end_time', $schedule->morning_end_time) }}" required>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="col-md-6">
      {{-- ================= EVENING SHIFT ================= --}}
      <div class="card mb-4">
         <div class="card-header fw-bold">Evening Shift</div>
         <div class="card-body">
            <div class="mb-3">
               <label class="form-label">Location</label>
               <input type="text" name="evening_location" class="form-control"
                  value="{{ old('evening_location', $schedule->evening_location) }}">
            </div>
            <div class="row">
               <div class="col-md-6 mb-3">
                  <label class="form-label">Start Time</label>
                  <input type="time" name="evening_start_time" class="form-control"
                     value="{{ old('evening_start_time', $schedule->evening_start_time) }}">
               </div>
               <div class="col-md-6 mb-3">
                  <label class="form-label">End Time</label>
                  <input type="time" name="evening_end_time" class="form-control"
                     value="{{ old('evening_end_time', $schedule->evening_end_time) }}">
               </div>
            </div>
         </div>
      </div>
   </div>
</div>