@extends('layouts.app')

@section('title', 'Schedule Calendar')

@section('styles')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css" rel="stylesheet">
@endsection

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Schedule Calendar</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('admin.schedules.index') }}"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Schedule Calendar</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('schedules.create')
                    <a href="{{ route('admin.schedules.create') }}" class="btn btn-sm btn-primary mb-3">
                        Add Schedule
                    </a>
                @endcan
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <div id="scheduleCalendar"></div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    const calendarEl = document.getElementById('scheduleCalendar');

    const events = [
        @foreach($schedules as $schedule)
            {
                id: "{{ $schedule->id }}-morning",
                title: "{{ $schedule->user->name ?? 'Schedule' }} (Morning)",
                start: "{{ \Carbon\Carbon::parse($schedule->schedule_date)->format('Y-m-d') }}T{{ \Carbon\Carbon::parse($schedule->morning_start_time)->format('H:i:s') }}",
                end: "{{ \Carbon\Carbon::parse($schedule->schedule_date)->format('Y-m-d') }}T{{ \Carbon\Carbon::parse($schedule->morning_end_time)->format('H:i:s') }}",
                url: "{{ route('admin.schedules.show', $schedule->id) }}", // Navigate to show page
                backgroundColor: '#0d6efd', // Bootstrap primary color
                borderColor: '#0d6efd',
                extendedProps: {
                    location: "{{ $schedule->morning_location }}",
                    fees: "{{ $schedule->fees }}"
                }
            }
            @if($schedule->evening_start_time),
            {
                id: "{{ $schedule->id }}-evening",
                title: "{{ $schedule->user->name ?? 'Schedule' }} (Evening)",
                start: "{{ \Carbon\Carbon::parse($schedule->schedule_date)->format('Y-m-d') }}T{{ \Carbon\Carbon::parse($schedule->evening_start_time)->format('H:i:s') }}",
                end: "{{ \Carbon\Carbon::parse($schedule->schedule_date)->format('Y-m-d') }}T{{ \Carbon\Carbon::parse($schedule->evening_end_time)->format('H:i:s') }}",
                url: "{{ route('admin.schedules.show', $schedule->id) }}", // Navigate to show page
                backgroundColor: '#0d6efd', // Bootstrap primary color
                borderColor: '#0d6efd',
                extendedProps: {
                    location: "{{ $schedule->evening_location }}",
                    fees: "{{ $schedule->fees }}"
                }
            }
            @endif
            @if(!$loop->last),@endif
        @endforeach
    ];

    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        height: 650,
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay'
        },
        events: events,
        navLinks: true,
        editable: false,
        selectable: false
    });

    calendar.render();
});
</script>
@endsection
