@extends('layouts.app')

@section('title', 'Add Schedule')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Add Schedule</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('admin.schedules.index') }}"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Add Schedule</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('schedules.view')
                    <a href="{{ route('admin.schedules.index') }}" class="btn btn-sm btn-primary mb-3">
                        View Schedules
                    </a>
                @endcan
            </div>
        </div>
        <div class="card">
            <div class="card-body">

                <form action="{{ route('admin.schedules.store') }}" method="POST">
                    @csrf

                    @include('schedules._form', ['schedule' => null])

                    <div class="mt-3">
                        <button class="btn btn-primary">Save Schedule</button>
                        <a href="{{ route('admin.schedules.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection
