@extends('layouts.app')

@section('title', 'Schedules')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3"> Schedule</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('admin.schedules.index') }}"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Schedule</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('schedules.create')
                    <a href="{{ route('admin.schedules.create') }}" class="btn btn-primary btn-sm mb-3">
                        <i class="bi bi-plus-circle"></i> Add Schedule
                    </a>
                @endcan
                @can('schedules.view')
                <a href="{{ route('admin.schedules.calendar') }}" class="btn btn-sm btn-info mb-3">
                    <i class="bi bi-calendar-event"></i> Calendar View
                </a>
                @endcan
            </div>
        </div>


        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body table-responsive">
                <table id="schedulesTable" class="table table-striped table-hover display">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>User</th>
                            <th>Company</th>
                            <th>Date</th>
                            <th>Morning</th>
                            <th>Evening</th>
                            <th>Fees</th>
                            <th>Status</th>
                            <th width="160">Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th></th>
                            <th>User</th>
                            <th>Company</th>
                            <th>Date</th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th>Status</th>
                            <th></th>
                        </tr>
                    </tfoot>
                    <tbody>
                        @forelse($schedules as $schedule)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $schedule->user->name ?? '-' }}</td>
                                <td>{{ $schedule->company->name ?? '-' }}</td>
                                <td>{{ $schedule->schedule_date->format('Y-m-d') }}</td>
                                <td>
                                    {{ $schedule->morning_location }}<br>
                                    {{ $schedule->morning_start_time }} - {{ $schedule->morning_end_time }}
                                </td>
                                <td>
                                    @if($schedule->evening_location)
                                        {{ $schedule->evening_location }}<br>
                                        {{ $schedule->evening_start_time }} - {{ $schedule->evening_end_time }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td>{{ number_format($schedule->fees, 2) }}</td>
                                <td>
                                    <span class="badge bg-{{ $schedule->status ? 'success' : 'secondary' }}">
                                        {{ $schedule->status ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td class="d-flex gap-1">
                                    <a href="{{ route('admin.schedules.show', $schedule) }}" class="btn btn-info btn-sm">View</a>
                                    @can('schedules.edit')
                                        <a href="{{ route('admin.schedules.edit', $schedule) }}" class="btn btn-warning btn-sm">Edit</a>
                                    @endcan
                                    @can('schedules.delete')
                                        <form action="{{ route('admin.schedules.destroy', $schedule) }}" method="POST"
                                              onsubmit="return confirm('Are you sure?')">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-danger btn-sm">Delete</button>
                                        </form>
                                    @endcan
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center">No schedules found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $schedules->links() }}
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $("#schedulesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            // Add column filters for User, Company, Date, Status
            this.api().columns([1,2,3,7]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
@endsection
