@extends('layouts.app')

@section('title', 'Schedule Details')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3"> Schedule Details</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('admin.schedules.index') }}"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Schedule Details</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('schedules.create')
                    <a href="{{ route('admin.schedules.create') }}" class="btn btn-primary btn-sm mb-3">
                        <i class="bi bi-plus-circle"></i> Add Schedule
                    </a>
                @endcan
                @can('schedules.view')
                    <a href="{{ route('admin.schedules.calendar') }}" class="btn btn-sm btn-info mb-3">
                        <i class="bi bi-calendar-event"></i> Calendar View
                    </a>
                @endcan
            </div>
        </div>

        {{-- Schedule Summary --}}
        <div class="card mb-3">
            <div class="card-body row">
                <div class="col-md-4">
                    <p><strong>User:</strong> {{ $schedule->user->name }}</p>
                    <p><strong>Company:</strong> {{ $schedule->company->name }}</p>
                    <p><strong>Status:</strong> 
                        <span class="badge bg-{{ $schedule->status ? 'success' : 'secondary' }}">
                            {{ $schedule->status ? 'Active' : 'Inactive' }}
                        </span>
                    </p>
                </div>
                <div class="col-md-4">
                    <p><strong>Total Slots:</strong> {{ $slots->count() }}</p>
                    <p><strong>Fees:</strong> {{ number_format($schedule->fees, 2) }}</p>
                    <p><strong>Total Fees:</strong> {{ number_format($slots->sum('fees'), 2) }}</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Schedule Date:</strong> {{ $schedule->schedule_date->format('Y-m-d') }}</p>
                    <p><strong>Per Customer Time:</strong> {{ $schedule->per_customer_time }} mins</p>
                    <p><strong>Morning Location:</strong> {{ $schedule->morning_location }}</p>
                    <p><strong>Evening Location:</strong> {{ $schedule->evening_location }}</p>
                </div>
            </div>
        </div>

        {{-- Slots Table --}}
        <div class="card">
            <div class="card-body">
                <h5>Slots</h5>
                <div class="table-responsive">
                    <table id="slotsTable" class="table table-striped table-hover display">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Shift</th>
                                <th>Location</th>
                                <th>Start Time</th>
                                <th>End Time</th>
                                <th>Fees</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th></th>
                                <th>Shift</th>
                                <th>Location</th>
                                <th></th>
                                <th></th>
                                <th>Fees</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @forelse($slots as $index => $slot)
                                @php
                                    $booking = $slot->booking;
                                    $rowClass = '';
                                    $actionButton = '<a href="'.route('admin.bookings.create', ['slot_id' => $slot->id]).'" class="btn btn-sm btn-success">Book</a>';

                                    if($booking){
                                        switch($booking->status){
                                            case 'pending': $rowClass = 'table-warning'; break;
                                            case 'confirmed': $rowClass = 'table-success'; break;
                                            case 'cancelled': $rowClass = 'table-danger'; break;
                                            case 'completed': $rowClass = 'table-info'; break;
                                        }
                                        $actionButton = '<span class="badge bg-dark text-white">Booked</span>';
                                    }
                                @endphp
                                <tr class="{{ $rowClass }}">
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ ucfirst($slot->shift) }}</td>
                                    <td>{{ $slot->location }}</td>
                                    <td>{{ \Carbon\Carbon::parse($slot->start_time)->format('H:i') }}</td>
                                    <td>{{ \Carbon\Carbon::parse($slot->end_time)->format('H:i') }}</td>
                                    <td>{{ number_format($slot->fees, 2) }}</td>
                                    <td>{!! $actionButton !!}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">No slots found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $("#slotsTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            // Column filters for Shift, Location, Fees
            this.api().columns([1,2,5]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
@endsection
